if (Test-Path "list.csv"){
	$entry = Import-Csv "list.csv"
	$word = New-Object -ComObject word.application
	$word.visible = $false
	$entries = $word.AutoCorrect.entries

	Foreach($e in $entry)
		{
			Try { $entries.add($e.replace, $e.with) | out-null }
			Catch [system.exception] { "unable to add $($e.replace)" }

		} #end foreach

	$word.Quit()
	$word = $null
	[gc]::collect()
	[gc]::WaitForPendingFinalizers()

	$Shell = New-Object -ComObject "WScript.Shell"
	$Button = $Shell.Popup("The AutoCorrect Script for NWT Place Names [Build Date 2025.02.03] has finished running. Please open a Microsoft Office document to see it work. Click OK to continue.", 0, "AutoCorrect Entries Successfully Installed", 0)
} else {
	$Shell = New-Object -ComObject "WScript.Shell"
	$Button = $Shell.Popup("The AutoCorrect Script was not able to find the NWT Place Names. Click OK to continue.", 0, "AutoCorrect Script Failed", 0)
}
